<?php

/**
 * Customers Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Customers extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Group_customers_model');
		$this->load->model('Customers_model');
		$this->load->model('Special_prices_model');
		$this->load->model('Sales_orders_model');
	}

	public function index()
	{
		$data['content_title'] = 'Pelanggan';

		$this->twiggy_display('adm/customers/index', $data);
	}

	public function get_data()
	{
		$data = [];
		$get_data = $this->Customers_model->get_data()->result();

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$so_data = false;
				$whe_salesorder = array('sales_order_header_customer_id' => $get_row->customer_id);
				$get_salesorder = $this->Sales_orders_model->salesorder_header($whe_salesorder)->result();

				if ($get_salesorder) {
					$so_data = true;
				}

				$payment_term = ($get_row->customer_payment_term == "0" ? "-" : $get_row->customer_payment_term . " Hari");

				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->customer_id,
					'name'         => $get_row->customer_name,
					'group'        => $get_row->group_customer_name,
					'telephone'    => $get_row->customer_telephone,
					'address'      => $get_row->customer_address,
					'payment_term' => $payment_term,
					'username'     => $get_row->customer_username,
					'password'     => $get_row->customer_password,
					'pin'          => $get_row->customer_pin,
					'ktp'          => $get_row->customer_ktp,
					'npwp'         => $get_row->customer_npwp,
					'limit_debt'     => number_format($get_row->customer_limit_debt),
					'limit_debt_trx' => number_format($get_row->customer_limit_debt_trx),
					'so_data'      => $so_data
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title    = "Tambah";
		$get_data = array();
		$limit_piutang = 0;

		if ($id != 'new') {
			$title    = "Edit";
			$where = array('customer_id' => $id);
			$get_data = $this->Customers_model->get_data($where)->row_array();
			$limit_piutang = number_format($get_data['customer_limit_debt']);
		}

		$data['id']              = $id;
		$data['g_customer_data'] = $this->Group_customers_model->get_data()->result();
		$data['content_title']   = $title;
		$data['get_data']        = $get_data;
		$data['limit_piutang']   = $limit_piutang;

		$this->twiggy_display('adm/customers/edit', $data);
	}

	public function save()
	{
		// post
		$id             = $this->input->post('id');
		$name           = $this->input->post('name');
		$group_customer = $this->input->post('group_customer');
		$telephone      = $this->input->post('telephone');
		$address        = $this->input->post('address');
		$payment_term   = $this->input->post('payment_term');
		$username       = $this->input->post('username');
		$password       = $this->input->post('passwords');
		$pin            = $this->input->post('pin');
		$ktp            = $this->input->post('ktp');
		$npwp           = $this->input->post('npwp');
		$limit_debt           = $this->input->post('limit_debt');
		$limit_debt_trx           = $this->input->post('limit_debt_trx');
		$action         = $this->input->post('action');

		$data_save = array(
			'customer_name'         => $name,
			'group_customer_id'     => $group_customer,
			'customer_telephone'    => $telephone,
			'customer_address'      => $address,
			'customer_payment_term' => $payment_term,
			'customer_username'     => $username,
			'customer_password'     => $password,
			'customer_pin'          => $pin,
			'customer_ktp'          => $ktp,
			'customer_npwp'         => $npwp,
			'customer_limit_debt'     => trims($limit_debt),
			'customer_limit_debt_trx' => trims($limit_debt_trx),
		);

		if ($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Customers_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Customers_model->update($id, $data_save);
		}

		if ($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		} else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_type = $this->Customers_model->delete($row);
			$delete_type_detail = $this->Special_prices_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id()
	{
		$username  = $this->input->post('id');
		$where     = array('customer_username' => $username);

		$check = $this->Customers_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}
}
